<?php

namespace App\Controllers;

use App\Models\ProjectModel;

class ProjectsController extends BaseController
{
    protected $projectModel;

    public function __construct()
    {
        $this->projectModel = new ProjectModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search') ?? '';
        $filter = [
            'jenis_project' => $this->request->getGet('jenis_project') ?? '',
            'tahun' => $this->request->getGet('tahun') ?? ''
        ];
        $sort = $this->request->getGet('sort') ?? 'urutan';
        $order = $this->request->getGet('order') ?? 'ASC';
        $page = (int)($this->request->getGet('page') ?? 1);

        $builder = $this->projectModel->searchAndFilter($search, $filter, $sort, $order);
        $total = $builder->countAllResults(false);
        
        $perPage = 10;
        $projects = $builder->get($perPage, ($page - 1) * $perPage)->getResultArray();

        $pager = \Config\Services::pager();
        $pager->store('projects', $page, $perPage, $total);
        
        // Calculate last page manually to ensure it works
        $lastPage = (int) ceil($total / $perPage);

        $data = [
            'title' => 'Project - Portfolio',
            'projects' => $projects,
            'pager' => $pager,
            'lastPage' => $lastPage,
            'currentPage' => $page,
            'total' => $total,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order
        ];

        return view('projects/index', $data);
    }
}

